import org.serviio.library.metadata.*
import org.serviio.library.online.*

/**
 * WebResource extractor plugin for www.allocine.fr
 *
 * @author Illico
 * @version 1.0
 *
 */
class AlloCine extends WebResourceUrlExtractor {

	final VALID_FEED_URL = 'http://www.allocine.fr.*'
	
	String getExtractorName() {
		return getClass().getName()
	}
	
	boolean extractorMatches(URL feedUrl) {
		return feedUrl ==~ VALID_FEED_URL
	}
	
	WebResourceContainer extractItems(URL resourceUrl, int maxItems) {		
		String WebResourceTitle = "Allocine.fr"    
		String WebResourceThumbnailUrl = "http://www.1jour1app.com/images/LogoAllocine.png"	
		String playerHtml = resourceUrl.getText()
		def img_lit    = playerHtml =~ '<img src=\'(.*)\''
			assert img_lit.getCount() > 0, "Error d'extraction de la liste des images"
		def media_list = playerHtml =~ '<a.*href=./video/player_gen_cmedia=(\\d*)&cfilm=\\d*.html.*>\\n.*<strong>(.*)</strong>'
			assert media_list.getCount() > 0, "Error d'extraction de la liste des medias"

		List<WebResourceItem> items = []        
		def ItemsAdded = 0;
		for( int i = 0; i < media_list.getCount() ; i++ ) {
			String WebResourceItemTitle        = media_list[i][2]
			String WebResourceItemId           = media_list[i][1]
			String WebResourceItemThumbnailUrl = img_lit[i][1]
			WebResourceItem item = new WebResourceItem(title: WebResourceItemTitle, additionalInfo: ['WebResourceItemId': WebResourceItemId, 'WebResourceItemThumbnailUrl': WebResourceItemThumbnailUrl])
			items << item
			ItemsAdded++ 			
		}
		return new WebResourceContainer(title: WebResourceTitle, thumbnailUrl: WebResourceThumbnailUrl, items: items)
	}
	
	ContentURLContainer extractUrl(WebResourceItem item, PreferredQuality requestedQuality) {		
		String media_url  = "http://www.allocine.fr/skin/video/AcVisionData_xml.asp?media="+item.getAdditionalInfo()['WebResourceItemId']
		String media_data = new URL(media_url).getText("UTF-8")
		def AcVisionNodes = new XmlParser().parseText(media_data)
			assert AcVisionNodes.name() == "AcVision", "Error de rcupration des Info Media"
		String ContentUrl
		switch (requestedQuality) {
			case PreferredQuality.HIGH   : ContentUrl = AcVisionNodes.AcVisionVideo[0].@'hd_path' ;break;
			case PreferredQuality.MEDIUM : ContentUrl = AcVisionNodes.AcVisionVideo[0].@'md_path' ;break;
			case PreferredQuality.LOW    : ContentUrl = AcVisionNodes.AcVisionVideo[0].@'ld_path' ;break;
			default                      : ContentUrl = AcVisionNodes.AcVisionVideo[0].@'hd_path' ;break;
			}
				println "WebResourceItemTitle        : "+item.getTitle()
				println "WebResourceItemId           : "+item.getAdditionalInfo()['WebResourceItemId']
				println "WebResourceItemThumbnailUrl : "+item.getAdditionalInfo()['WebResourceItemThumbnailUrl']					
				println "ContentUrl                  : "+ContentUrl
		return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: ContentUrl, thumbnailUrl: item.getAdditionalInfo()['WebResourceItemThumbnailUrl'])
	}

/*********************************************
 * MAIN
 *********************************************/	
	static void main(args) {       
		def TestUrl = new URL("http://www.allocine.fr/video/bandes-annonces/toutes/?sort_order=1")
		AlloCine extractor = new AlloCine()        
			println "PluginName               : " + extractor.getExtractorName();
			println "TestMatch                : " + extractor.extractorMatches(TestUrl);
		WebResourceContainer container = extractor.extractItems(TestUrl, -1);
			println "**** HIGH ****"  ;extractor.extractUrl(container.getItems()[0], PreferredQuality.HIGH)
			println "**** MEDIUM ****";extractor.extractUrl(container.getItems()[0], PreferredQuality.MEDIUM)
			println "**** LOW ****"   ;extractor.extractUrl(container.getItems()[0], PreferredQuality.LOW)
	} 
}